<?php

namespace app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PackageDetails extends Model 
{

    protected $table = 'package_details_table';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function packageDetailsPackages()
    {
        return $this->hasOne('App\Models\Package', 'package_id');
    }

    public function packageDetailsItem()
    {
        return $this->hasMany('app\Models\Item', 'item_id');
    }

}